#include <math.h>
#include <string.h>
#include "tiny_ui_util_nOS.h"

void tiny_ui_Identity(tiny_ui_matrix_t * Matrix)
{
    // Set identify matrix.
    Matrix->m[0][0] = 1.0f;
    Matrix->m[0][1] = 0.0f;
    Matrix->m[0][2] = 0.0f;
    Matrix->m[1][0] = 0.0f;
    Matrix->m[1][1] = 1.0f;
    Matrix->m[1][2] = 0.0f;
    Matrix->m[2][0] = 0.0f;
    Matrix->m[2][1] = 0.0f;
    Matrix->m[2][2] = 1.0f;
}

static void multiply(tiny_ui_matrix_t * Matrix, tiny_ui_matrix_t * Mult)
{
    tiny_ui_matrix_t temp;
    int row, column;

    // Process all rows.
    for (row = 0; row < 3; row++)
    {
        // Process all columns.
        for (column = 0; column < 3; column++)
        {
            // Compute matrix entry.
            temp.m[row][column] = (  Matrix->m[row][0] * Mult->m[0][column]
                                   + Matrix->m[row][1] * Mult->m[1][column]
                                   + Matrix->m[row][2] * Mult->m[2][column]
                                   );
        }
    }

    // Copy temporary matrix into result.
    memcpy(Matrix, &temp, sizeof(temp));
}

void tiny_ui_Translate(tiny_ui_float_t X, tiny_ui_float_t Y, tiny_ui_matrix_t * Matrix)
{
    // Set translation matrix.
    tiny_ui_matrix_t t = { 1.0f, 0.0f, X, 0.0f, 1.0f, Y, 0.0f, 0.0f, 1.0f };

    // Multiply with current matrix.
    multiply(Matrix, &t);
}

void tiny_ui_Scale(tiny_ui_float_t ScaleX, tiny_ui_float_t ScaleY, tiny_ui_matrix_t * Matrix)
{
    // Set scale matrix.
    tiny_ui_matrix_t s = { ScaleX, 0.0f, 0.0f, 0.0f, ScaleY, 0.0f, 0.0f, 0.0f, 1.0f };

    // Multiply with current matrix.
    multiply(Matrix, &s);
}

void tiny_ui_Rotate(tiny_ui_float_t Degrees, tiny_ui_matrix_t * Matrix)
{
    // Convert degrees into radians.
    tiny_ui_float_t angle = Degrees / 180.0f * M_PI;

    // Compuet cosine and sine values.
    tiny_ui_float_t cosAngle = cosf(angle);
    tiny_ui_float_t sinAngle = sinf(angle);

    // Set rotation matrix.
    tiny_ui_matrix_t r = { cosAngle, -sinAngle, 0.0f, sinAngle, cosAngle, 0.0f, 0.0f, 0.0f, 1.0f };

    // Multiply with current matrix.
    multiply(Matrix, &r);
}
